
#include "RTC_M41T80M6F.h"

#include "main.h"
#include "stm32l4xx_hal.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

WakeTimer_t interrupt = Second;// interrupt period defaults to seconds on startup to enable HWinitialisation2() to run 2 secs after startup
uint32_t WakeTimerSecondsValue[4] = {1,60,3600,86400};// defines number of seconds in each interrupt category

/**
* @brief  resets rtc datetime as it is unneeded for SPaRAS function
* @return HAL_StatusTypeDef code status
*/
HAL_StatusTypeDef Reset_RTC_DateTime(void){
	 HAL_StatusTypeDef status = HAL_OK;
	 uint8_t sendBuf[2] = {0x00, 0};//register on rtc (data to send)

	 printf("Reset RTC DateTime\r\n");

	 while(sendBuf[0]<=0x03){// set miliseconds, seconds, minutes, and hours to 0
		status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, sendBuf, (uint16_t) 2, 1000); //Write to RPT1
		if(status!=HAL_OK) printf("I2C transmit error(write to %x) %d\r\n",sendBuf[0], status);
		HAL_Delay(5);
		sendBuf[0]+=1;
	 }
	 sendBuf[1] = 0x01;
	 while(sendBuf[0]<=0x06){// set day of week, date and month to 1
	 	status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, sendBuf, (uint16_t) 2, 1000); //Write to RPT1
	 	if(status!=HAL_OK) printf("I2C transmit error(write to %x) %d\r\n",sendBuf[0], status);
	 	HAL_Delay(5);
	 	sendBuf[0]+=1;
	 }

	 sendBuf[1]= 0x00;// set year to 0
	 status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, sendBuf, (uint16_t) 2, 1000); //Write to RPT1
	 if(status!=HAL_OK) printf("I2C transmit error(write to %x) %d\r\n",sendBuf[0], status);
	 HAL_Delay(5);
	 sendBuf[0]+=1;

     return status;
}

/**
* @brief  deactivate Repeat Alarm
* @return HAL_StatusTypeDef code status
*/
HAL_StatusTypeDef Deactivate_RTC_RPTAlarm(void){
      uint8_t txbuf[10];
	  uint8_t rx_bytes[10];
	  HAL_StatusTypeDef status = HAL_OK;
	  printf("Deactivate RTC\r\n");

	  txbuf[0]=0x0E;
	  txbuf[1]=0;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000); //Write 0 to register 0x0E(RPT1)
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0E) %d\r\n", status);
	  HAL_Delay(10);

	  txbuf[0]=0x0D;
	  txbuf[1]=0;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000);//Write 0 to register 0x0D(RPT2)
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0D) %d\r\n", status);
	  HAL_Delay(10);

	  txbuf[0]=0x0C;
	  txbuf[1]=0;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000);//Write 0 to register 0x0C(RPT3)
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0C) %d\r\n", status);
	  HAL_Delay(10);

	  txbuf[0]=0x0B;
	  txbuf[1]=0;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000);//Write 0 to register 0x0B(RPT4 and RPT5)
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0B) %d\r\n", status);
	  HAL_Delay(10);

	  txbuf[0]=0x0A;
	  txbuf[1]=0;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000);//Write 0 to register 0x0A(AFE-Alarm Flag)
	  if(status!=HAL_OK) printf("I2C transmit error (write to 0x0A) %d\r\n", status);
	  HAL_Delay(10);

	  txbuf[0]=0x08;
	  txbuf[1]=0;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000);//Write 0 to register 0x08(OUT)
	  if(status!=HAL_OK) printf("I2C transmit error (write to 0x08) %d\r\n", status);
	  HAL_Delay(10);

	  txbuf[0]=0x0F;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 1, 1000);//Clear IRQ flag ny reading from AF
	  if(status!=HAL_OK) printf("I2C transmit error (clearIRQFlag) %d\r\n", status);
	  HAL_Delay(1);	//Wait before sending read 0.01 sec

	  status=HAL_I2C_Master_Receive(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, rx_bytes, (uint16_t) 1, 1000);  //Read the data
	  if(status!=HAL_OK) printf("I2C receive error(RTCRead) %d\r\n", status);


 return status;
}

/**
* @brief  configure repeat alarm according to global interrupt variable
* @return HAL_StatusTypeDef code status
*/
HAL_StatusTypeDef Config_RTC_RPTAlarm(){
      uint8_t txbuf[10];
	  uint8_t rx_bytes[10];

	  uint8_t RPT1Buf[2] = {0x0E, 0};//addresses for each register to write to
	  uint8_t RPT2Buf[2] = {0x0D, 0};
	  uint8_t RPT3Buf[2] = {0x0C, 0};
	  uint8_t RPT45Buf[2] = {0x0B, 0};
	  HAL_StatusTypeDef status = HAL_OK;
	  if(interrupt == Second){//changing writing configurations based on desired interrupt
		  RPT1Buf[1] = 0x80;
		  RPT2Buf[1] = 0x80;
		  RPT3Buf[1] = 0x80;
		  RPT45Buf[1] = 0xC0;
	  }else if (interrupt == Minute){
		  RPT1Buf[1] = 0x0;
		  RPT2Buf[1] = 0x80;
		  RPT3Buf[1] = 0x80;
		  RPT45Buf[1] = 0xC0;

	  }else if (interrupt == Hour){
		  RPT1Buf[1] = 0x0;
		  RPT2Buf[1] = 0x0;
		  RPT3Buf[1] = 0x80;
		  RPT45Buf[1] = 0xC0;

	  }else{ // Day
		  RPT1Buf[1] = 0x0;
		  RPT2Buf[1] = 0x0;
		  RPT3Buf[1] = 0x0;
		  RPT45Buf[1] = 0xC0;

	  }

	  printf("Config RTC\r\n");
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, RPT1Buf, (uint16_t) 2, 1000); //Write to RPT1
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0E) %d\r\n", status);
      HAL_Delay(5);

	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, RPT2Buf, (uint16_t) 2, 1000); //Write to RPT2
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0D) %d\r\n", status);
	  HAL_Delay(5);

	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, RPT3Buf, (uint16_t) 2, 1000); //Write to RPT3
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0C) %d\r\n", status);
	  HAL_Delay(5);

	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, RPT45Buf, (uint16_t) 2, 1000); //Write to RPT4 and 5
	  if(status!=HAL_OK) printf("I2C transmit error(write to 0x0B) %d\r\n", status);
	  HAL_Delay(5);

	  txbuf[0]=0x0A;
	  txbuf[1]=0x80;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000); //Write to AFE(alarm flag enabled to 1)
	  if(status!=HAL_OK) printf("I2C transmit error (write to 0x0A) %d\r\n", status);
	  HAL_Delay(5);

	  txbuf[0]=0x08;
	  txbuf[1]=0x80;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 2, 1000);// write to OUT to enable it
	  if(status!=HAL_OK) printf("I2C transmit error (write to 0x08) %d\r\n", status);
	  HAL_Delay(5);

	  txbuf[0]=0x0F;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 1, 1000);//Clear IRQ flag by reading from AF
	  if(status!=HAL_OK) printf("I2C transmit error (clearIRQFlag) %d\r\n", status);

	  HAL_Delay(1);	//Wait before sending read 0.01 sec

	  status=HAL_I2C_Master_Receive(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, rx_bytes, (uint16_t) 1, 1000);//Read the data
	  if(status!=HAL_OK) printf("I2C receive error(RTCRead) %d\r\n", status);

	  HAL_Delay(10);
	  return status;
}

/**
* @brief  clear alarm flag after each activation to reset it
*/
void Reset_RTC_RPTAlarm(){

 	  uint8_t txbuf[10];
	  uint8_t rx_bytes[10];
	  HAL_StatusTypeDef status = HAL_OK;

	  //Clear IRQ flag
	  txbuf[0]=0x0F;
	  status=HAL_I2C_Master_Transmit(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, txbuf, (uint16_t) 1, 1000);
	  if(status!=HAL_OK)
	  {
		  printf("Reset: I2C transmit error(write to 0x0F) %d\r\n", status);
	  }
	  else
	  {
		  status=HAL_I2C_Master_Receive(&hi2c2, (uint16_t) EXT_RTC_ADDRESS, rx_bytes, (uint16_t) 1, 1000); //Read the data
		  if(status!=HAL_OK) printf("I2C receive error(ReadRTC) %d\r\n", status);
	  }
}

/**
* @brief  initialises RTC in GPIO
*/
 void MX_GPIO_RTC_Init(void)
{
  GPIO_InitTypeDef GPIO_InitStruct = {0};

  //Configure GPIO pin : IRQ_RTC_Pin
  GPIO_InitStruct.Pin = IRQ_RTC_Pin;
  GPIO_InitStruct.Mode = GPIO_MODE_IT_FALLING;
  GPIO_InitStruct.Pull = GPIO_PULLUP;
  HAL_GPIO_Init(IRQ_RTC_GPIO_Port, &GPIO_InitStruct);

  //EXTI interrupt init

 // EXTI_HandleTypeDef simon_exti[] = {{.Line = EXTI_LINE_1}};
//  HAL_EXTI_GetHandle(&simon_exti[0], EXTI_LINE_1);
 // HAL_EXTI_RegisterCallback(&simon_exti[0],  HAL_EXTI_COMMON_CB_ID, my_callback);


  HAL_NVIC_SetPriority(EXTI1_IRQn, 0, 0);
  HAL_NVIC_EnableIRQ(EXTI1_IRQn);



}




